<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

// Only allow admin users
if (!isset($_SESSION['user_id']) || getUserRole() !== 'Administrator') {
    die('Access denied. Only administrators can reset the system.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_reset'])) {
    try {
        // Disable foreign key checks
        $pdo->exec('SET FOREIGN_KEY_CHECKS=0');
        // Truncate tables (keep users, roles, permissions, settings)
        $pdo->exec('TRUNCATE TABLE sales');
        $pdo->exec('TRUNCATE TABLE sale_items');
        $pdo->exec('TRUNCATE TABLE customers');
        $pdo->exec('TRUNCATE TABLE credit_transactions');
        $pdo->exec('TRUNCATE TABLE stock_transactions');
        $pdo->exec('TRUNCATE TABLE products');
        // Enable foreign key checks
        $pdo->exec('SET FOREIGN_KEY_CHECKS=1');
        $success = 'System data has been reset successfully!';
    } catch (PDOException $e) {
        $error = 'Error resetting system: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset POS System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-danger text-white">
                    <h4 class="mb-0">Reset POS System Data</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($success)): ?>
                        <div class="alert alert-success"><?php echo $success; ?></div>
                    <?php elseif (!empty($error)): ?>
                        <div class="alert alert-danger"><?php echo $error; ?></div>
                    <?php else: ?>
                        <div class="alert alert-warning">
                            <strong>Warning:</strong> This will delete all sales, customers, products, credit, and stock data. <br>
                            <b>Users, roles, permissions, and settings will NOT be deleted.</b><br>
                            This action cannot be undone.
                        </div>
                        <form method="post">
                            <button type="submit" name="confirm_reset" class="btn btn-danger" onclick="return confirm('Are you sure you want to reset all POS data? This cannot be undone!');">
                                Yes, Reset System Data
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
